﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
if (typeof (question) === "undefined") {
    var question = {};
}

question.mid4074 = {
    //general options and settings
    opts: {
        questions: {
            hideByDefault: function () {
                return $('div[id$="TID2_QID1"],div[id$="TID2_QID2"],div[id$="TID2_QID3"],div[id$="TID2_QID4"],div[id$="TID2_QID5"],div[id$="TID2_QID6"],div[id$="TID2_QID7"],div[id$="TID2_QID8"],div[id$="TID2_QID9"],div[id$="TID2_QID10"]');
            },
            _qTID1QID1: 'TID1_QID1'
        }
    },

    //hide questions by default
    hideQuestions: function () {
        var _me = this;

        $.each(_me.opts.questions.hideByDefault(), function (i, _divQ) {

            //set 'skipped' attribute
            $(_divQ).attr('skipped', true);
            $('[name^="grp"]', $(_divQ)).each(function () {
                var _name = $(this).attr('name');
                if (_name.indexOf("skip_") < 0) {
                    $(this).attr("name", "skip_" + _name);
                }
            });

            //no need to reset question's responses as is the first time loading and there are no answers
            //_me.clearQuestionResponses(_divQ);

            //hide question
            $(_divQ).hide();

        });

        $('#TID2').hide();

    },

    //bind responses click event
    bindResponseClick: function () {
        var _me = this,
            _divQTID1QID1 = $('div[id$="' + _me.opts.questions._qTID1QID1 + '"]');

        $('input[type="radio"]', _divQTID1QID1).each(function (i, ele) {
            $(ele).bind({
                click: function (e) {
                    if ($('#TID2').is(':visible') == false) {
                        $('#TID2').show();
                    }
                }
            });
        });

    },

    //initializing functions
    init: function (callback) {
        var _me = this;

        //wait for DOM readiness
        $(document).ready(function () {
            Ext.onReady(function () {
                setTimeout(function () {
                    //call functions here
                    _me.hideQuestions();
                    _me.bindResponseClick();

                    //Successful
                    if (callback) {
                        if (typeof (callback.success) == "function") {
                            callback.success();
                        }
                    }
                }, 1);
            });
        });
    }
};